import java.util.*;
import java.io.*;

public class MimeDatabase {
    private Properties m_prMimeDatabase;
    public static final String unknownMime = "text/plain"; //should be "application/unknown";

    public MimeDatabase(VHostConf hcm, httpdconf sc) {
        super();
        m_prMimeDatabase = new Properties();
        try {
            FileInputStream fis = new FileInputStream(hcm.getMimeDatabaseFile());
            m_prMimeDatabase.load(fis);
            if(sc.getDebugLevel() > 3)
                sc.println(Thread.currentThread().getName(), "MimeDatabase: Loaded MIME types from \""+hcm.getMimeDatabaseFile()+"\"...");
        } catch (IOException e) {
            if(sc.getDebugLevel() > 3)
                sc.errln(Thread.currentThread().getName(), "MimeDatabase: Could not find MIME config file.  Using defaults...");
            //insert our defaults...
            m_prMimeDatabase.put("htm", "text/html");
            m_prMimeDatabase.put("html", "text/html");
            m_prMimeDatabase.put("txt", "text/plain");
            m_prMimeDatabase.put("zip", "application/x-zip-compressed");
            m_prMimeDatabase.put("jar", "application/x-zip-compressed");
        }
    }

    public String getMimeType(String fname) {
        int loc = fname.lastIndexOf('.');
        if(loc >= 0) {
            String ext = fname.substring(loc+1).toLowerCase();
            return m_prMimeDatabase.getProperty(ext, unknownMime);
       } else return unknownMime;
    }

    public String getMimeType(File f) throws IOException {
        return getMimeType(f.getCanonicalPath());
    }

    public String getIcon(String fm) throws IOException {
        return getIcon(new File(fm));
    }
    
    public String getIcon(File f) throws IOException {
        if(f.isDirectory()) return "folder.gif";
        String mimeType = getMimeType(f);
        if(mimeType.startsWith("image")) return "image.gif";
        if(mimeType.startsWith("text")) return "text.gif";
        if(mimeType.startsWith("audio")) return "audio.gif";
        if(mimeType.startsWith("video")) return "video.gif";
        if(mimeType.equals(unknownMime)) return "unknown.gif";
        if(mimeType.startsWith("application")) return "app.gif";
        return "unknown.gif";
    }
}
