/*
 * uptime.c -- Read uptime information
 * Copyright (C) 2006 Darrick Wong
 */
#include <stdio.h>
#include <stdint.h>
#include "ugh.h"

/* Print uptime */
void process_uptime(void)
{
	uint32_t days, hours, minutes;
	float uptime, seconds, idle;
	FILE *fp;
	int x;

	fp = fopen("/proc/uptime", "r");
	if (!fp) {
		perror("/proc/uptime");
		return;
	}

	x = fscanf(fp, "%f %f", &uptime, &idle);
	if (x != 2) {
		perror("/proc/uptime");
		fclose(fp);
		return;
	}

	fclose(fp);

	seconds = uptime;
	days = seconds / (24*3600);
	seconds -= days * (24*3600);

	hours = seconds / 3600;
	seconds -= hours * 3600;

	minutes = seconds / 60;
	seconds -= minutes * 60;

	printf("Uptime: ");
	x = 0;
	if (days) {
		printf("%d days", days);
		x++;
	}

	if (x)
		printf(", ");

	printf("%02d:%02d:%02d", hours, minutes, (int)seconds);
	
	printf("  Activity: %.2f%%", (uptime - idle) / uptime * 100);

	printf(CLR_EOL);
}
