/*
 * uname.c -- Print uname
 * Copyright (C) 2006 Darrick Wong
 */
#include <stdio.h>
#include <sys/utsname.h>
#include <stdlib.h>
#include "ugh.h"

static char *buf;
static unsigned int buflen;

/* Init uname */
int init_uname(void)
{
	unsigned short w;

	w = get_window_width();
	buf = malloc(w);
	buflen = w;

	return 1;
}

/* Print uname */
void process_uname(void)
{
	struct utsname moo;
	unsigned short w;

	w = get_window_width();

	if (buflen != w) {
		free(buf);
		buf = malloc(w);
		buflen = w;
	}

	if (uname(&moo)) {
		perror("uname");
		return;
	}

	snprintf(buf, buflen, "%s %s %s %s %s",
		moo.sysname,
		moo.nodename,
		moo.release,
		moo.version,
		moo.machine);
	printf("%s%s\n", buf, CLR_EOL);
}
