/*
 * loadavg.c -- Print load average.
 */
#include <stdio.h>
#include "ugh.h"

/* Print load averages */
void process_loadavg(void)
{
	int x;
	FILE *fp;
	float avgs[3];

	fp = fopen("/proc/loadavg", "r");
	if (!fp)
		return;

	x = fscanf(fp, "%f %f %f", avgs, avgs + 1, avgs + 2);
	if (x)
		printf("  Load: %.2f %.2f %.2f\n", avgs[0], avgs[1], avgs[2]);

	fclose(fp);
}
