package jrand.ui;

import javax.swing.*;
import jrand.event.*;
import jrand.*;

public class CFGListModel extends AbstractListModel implements CFGListDataListener {
	private CFGList list;
	
	public CFGListModel(CFGList _list) {
		list = _list;
		list.addCFGListDataListener(this);
	}

	public void finalize() {
		list.removeCFGListDataListener(this);
	}

	public int getSize() {
		return list.getListSize();
	}

	public Object getElementAt(int at) {
		return list.getRuleName(at);
	}

 	public void contentsChanged(CFGListDataEvent e) {
		fireContentsChanged(e.getSource(), e.getIndex0(), e.getIndex1());
	}
	
	public void intervalAdded(CFGListDataEvent e) {
		fireIntervalAdded(e.getSource(), e.getIndex0(), e.getIndex1());
	}
	
	public void intervalRemoved(CFGListDataEvent e) {
		fireIntervalRemoved(e.getSource(), e.getIndex0(), e.getIndex1());
	}

	public void rootChanged(CFGListDataEvent e) {
		fireContentsChanged(e.getSource(), e.getIndex0(), e.getIndex1());
	}
}
