package jrand.parser;

import java.io.*;
import java.util.*;
import jrand.*;
import jrand.error.*;

public class CFGParser {
	private Reader input;
	private CFGTokenizer ct;
	private CFGList list;

	private int side;
	private final static int LEFT = 1;
	private final static int RIGHT = 2;

	public CFGParser(Reader boo) throws IOException {
		input = boo;
		ct = new CFGTokenizer(input);
		list = new CFGList();
	}

	public void parse() throws InvalidGrammarException {
		CFGToken ct0, ct1, thistok, nexttok;
		CFGNode thisnode, prevnode, headnode, combonode;
		String nodename;
		int numtokens, toktype;
		boolean incombo;
		Vector tokens = new Vector();
		boolean first = true;
		
		side = LEFT;
		while(ct.hasMoreTokens()) {
			tokens.setSize(0);

			ct0 = ct.nextToken();
			while(ct0 != null && ct0.getType() != CFGToken.ENDRULE) {
				tokens.addElement(ct0);
				//System.out.println("moo: "+ct0);
				ct0 = ct.nextToken();
			}

			//System.out.println("Now done reading line "+ct.getLineNumber());

			ct0 = (CFGToken)tokens.elementAt(0);
			ct1 = (CFGToken)tokens.elementAt(1);

			if(ct1.getType() != CFGToken.EQUALS) {
				System.err.println(ct.getLineNumber() + "Second token is not an equals! ");
				continue;
			}
			if(ct0.getType() != CFGToken.NODE && ct0.getType() != CFGToken.STRING) {
				System.err.println(ct.getLineNumber() + "First token is not a node! ");
				continue;
			}

			nodename = ct0.getName();

			headnode = makeNodesFromTokens2(tokens, ct.getLineNumber());

			if(headnode == null) {
				System.err.println("ERROR! No head node! Line "+ct.getLineNumber());
			} else {
				try {
					list.addRule(nodename, headnode);
				} catch (InvalidRuleNameException irne) {
					throw new InvalidGrammarException("Line "+ct.getLineNumber()+": "+irne.getMessage());
				}
				if(first) list.setRootName(nodename);
			}
			first = false;
		}
		
		//now go back and resolve all the nodes.
		Enumeration k = list.getRuleNames();
		String key;
		CFGNode cn;

		while(k.hasMoreElements()) {
			key = (String)k.nextElement();
			cn = list.getRule(key);

			while(cn != null) {
				cn.resolveNode(list);
				cn = cn.getNext();
			}
		}
	
	}

	private CFGNode makeNodesFromTokens2(Vector tokens, int line) {
		boolean incombo = false;
		int numtokens = tokens.size();
		CFGNode head, temp, tempend, newnode;
		CFGToken tok;
		int toktype;

		head = temp = tempend = newnode = null;

		//if < 2 tokens (i.e. "<bleh> =") then quit
		if(numtokens < 3) return null;

		//read all tokens, and...
		for(int i = 2; i < numtokens; i++) {
			//grab a token.
			tok = (CFGToken)tokens.elementAt(i);
			toktype = tok.getType();

			//if we've two equals, quit.
			if(toktype == CFGToken.EQUALS) {
				System.err.println(line+": Two equal signs; premature end of parsing.");
				break;
			}

			//if it's a pipe...
			if(toktype == CFGToken.OR) {
				//if the head of this is null, make a new one.
				if(head == null) {
					head = new CFGNode(CFGNode.COMBINATION);
				}
				//then add this collection
				head.addPossibility(temp);

				temp = tempend = null;
				incombo = true;
			} else { //otherwise we (hopefully) have a pointer, string or char.
				//formulate a new token.
				switch(toktype) {
					case CFGToken.NODE:
						newnode = new CFGNode(CFGNode.UNRESOLVED, tok.getName());
						break;
					case CFGToken.STRING:
					case CFGToken.CHAR:
						newnode = new CFGNode(CFGNode.STRING, tok.getName());
						break;
					default:
						System.err.println("ACK!  Token of type "+toktype+" in bad place!");
						continue;
				}

				//if there's an endpointer, just append.
				if(tempend != null) {
					tempend.setNext(newnode);
					newnode.setPrev(tempend);
					tempend = newnode;
				} else { //no endpointer; start a new list.
					temp = tempend = newnode;
				}
			}
		}

		//done processing tokens, now to finish up.
		//if we're in a combination, then add the last chain.
		if(incombo) {
			head.addPossibility(temp);
			temp = tempend = null;
		} else { //otherwise, just set the head to whatever we collected.
			head = temp;
		}

		return head;
	}

	public CFGList getList() {return list;}

	
}
