import java.io.*;
import java.util.*;

public class FunOutputStream extends OutputStream implements Runnable {
	private PipedOutputStream out;
	private PipedInputStream in;

	private OutputStream lastout;
	private Thread runner;

	public FunOutputStream(OutputStream lo) throws IOException {
		out = new PipedOutputStream();
		in = new PipedInputStream(out);

		lastout = lo;

		runner = new Thread(this);
		runner.start();
	}

	private final static char ansi_esc = 0x1B;

	public void run() {
		char inchar;
		
		while(true) {
			try {
				inchar = (char)in.read();
			} catch (IOException e) {
				return;
			}

			try {
				int dir = (int)Math.round(Math.random());
				lastout.write(ansi_esc);
				lastout.write('[');
				lastout.write('1');
				switch(dir) {
					case 0: lastout.write('A'); break;
					case 1: lastout.write('B'); break;
				}

				lastout.write(inchar);
				lastout.flush();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public void write(int b) throws IOException {
		out.write(b);
	}

	public void flush() throws IOException {
		lastout.flush();
	}

	public void close() throws IOException {
		lastout.close();
	}
}
