import java.applet.*;
import java.net.URL;
import java.security.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class MainInstaller extends Applet implements IScript, WindowListener, ActionListener {
   private Wizard p;
   private boolean Java12 = true;
   private boolean J3D = true;
   private boolean Swing = true;
   private CheckboxGroup cg = new CheckboxGroup();
   private int current = 0;
   private int iInstallOption = 0;
   private String sJavaVer = "unknown";
   private Checkbox ckHavePlugin = new Checkbox("Check here if you are using the Java Plugin.", false);
   private MyButton bHowToInstJar = new MyButton("How to install a JAR");

   public boolean isApp = false;

   private static final String name = "Periodic Table '99";

   public void onNext() {
       unsetPage(current);
       current++;
       setPage(current, true);
   }

   public void onBack() {
       unsetPage(current);
       current--;
       setPage(current, false);
   }

   private void unsetPage(int page) {
       switch(page) {
           case 1: {
               Checkbox cb = cg.getSelectedCheckbox();
               String s = cb.getLabel();
               if(s.equals("Standard (requires Java 1.1)")) {
                   iInstallOption = 1;
               } else if(s.equals("Optimized (requires Java 1.2)")) {
                   iInstallOption = 2;
               } else if(s.equals("3D (requires Java 1.2)")) {
                   iInstallOption = 3;
               }
           }
       }
   }

   private Panel pInstallOptions = null;
   private MyLabel l = new MyLabel();

   private void setPage(int page, boolean advancing) {
       switch(page) {
           case 0: {
               l.setText(welcome);
               p.setContent(l);
               p.getBack().setEnabled(false);
               break;
           } case 1: {
               try {getClass().forName("java.awt.image.BufferedImage");} // bi = new java.awt.image.BufferedImage(1,1,5);}
               catch (Throwable e) {Java12 = false;}

               try {javax.media.j3d.View v = new javax.media.j3d.View();}
               catch (Throwable e) {J3D = false;}

               try {javax.swing.JButton v = new javax.swing.JButton("gorf");}
               catch (Throwable e) {Swing = false;}

               J3D &= Java12; //no j12 means no j3d

               p.getBack().setEnabled(true);

               if(pInstallOptions == null) {
                   pInstallOptions = new Panel();
                   pInstallOptions.setLayout(new BorderLayout());

                   Panel px = new Panel();
                   px.setLayout(new GridLayout(3,1));

                   boolean s1=false, s2=false, s3=false;

                   if(J3D) s3 = true;
                   else if(Java12) s2 = true;
                   else s1 = true;

                   px.add(new Checkbox("Standard (requires Java 1.1)", s1, cg));
                   px.add(new Checkbox("Optimized (requires Java 1.2)", s2, cg));
                   px.add(new Checkbox("3D (requires Java 1.2)", s3, cg));
                   pInstallOptions.add("South", px);
               }
               l.setText("Which version of the Periodic Table would you like to use?");               
               pInstallOptions.add("Center", l);               
               p.setContent(pInstallOptions);
               break;
           } case 2: {
               //you need swing
               if((Swing) || (iInstallOption > 1)) {
                   if(advancing) current++; else current--;
                   setPage(current, advancing);
                   break;
               }
               Panel px = new Panel();
               px.setLayout(new BorderLayout());
               l.setText(
                   "This Java platform, Java "+sJavaVer+", does not support the "+
                   "JFC/Swing packages.  You need to get Swing from JavaSoft to"+
                   "run this program\n"+
                   "\n"+
                   "Swing is a set of Java extensions which provide for advanced GUI functionality needed for the Periodic Table.\n"+
                   "\n"+
                   "Once you have installed Swing, rerun this wizard.\n"
               );
               px.add("Center", l);

               MyButton b = new MyButton("Get Swing...");
               b.addActionListener(this);
               Panel pxx = new Panel();
               pxx.add(b);
               pxx.add(bHowToInstJar);
               px.add("South", pxx);

               p.setContent(px);
               break;
           } case 3: {
               //you need java 1.2 page.
               if((Java12) || (iInstallOption < 2)) {
                   if(advancing) current++; else current--;
                   setPage(current, advancing);
                   break;
               }
               Panel px = new Panel();
               px.setLayout(new BorderLayout());
               px.add("Center", l);
               l.setText(
                   "This Java platform, Java "+sJavaVer+", does not support the "+
                   "Java 1.2 APIs.  Click the button below to learn how to get "+
                   "Java 1.2 support.\n"+
                   "\n"+
                   "The Java Plugin lets you use any Java platform in any browser.\n"+
                   "Your Java platform's vendor may also have Java 1.2 updates available."+
                   "\n"+
                   "Once you have installed Java 1.2, rerun this wizard.\n"+
                   "\n"+
                   "Notes:\n"+
                   "======\n"+
                   "Windows 9x/NT: Netscape 4.05 has Java 1.1; Internet Explorer 4.0 has Java 1.1 and JavaSoft's Java Plugin does Java 1.1 or 1.2\n"+
                   "Solaris: Netscape 4.05 has Java 1.1; JavaSoft's JDK can do either Java 1.1 or 1.2\n"+
                   "Macintosh: Apple's MRJ 2.1 does Java 1.1; Internet Explorer 4.0 does 1.1 as well.\n"+
                   "Linux: Check your Java platform supplier.\n"
               );

               MyButton b = new MyButton("Get Java Plugin...");
               b.addActionListener(this);
               Panel pxx = new Panel();
               pxx.add(b);

               b = new MyButton("Go to Java vendor...");
               b.addActionListener(this);
               pxx.add(b);
               pxx.add(bHowToInstJar);
               px.add("South", pxx);

               p.setContent(px);
               break;
           } case 4: {
               //you need java3D
               if((J3D) || (iInstallOption < 3)) {
                   if(advancing) current++; else current--;
                   setPage(current, advancing);
                   break;
               }
               Panel px = new Panel();
               px.setLayout(new BorderLayout());
               px.add("Center", l);
               l.setText(
                   "You need to have Java3D in order to use the 3D features of "+
                   "the "+name+".  Click the button below to get Java3D.\n"+
                   "\n"+
                   "Java3D provides 3D graphics rendering on Windows and Solaris environments.\n"+
                   "\n"+
                   "Once you have installed Java3D, rerun this wizard."
               );

               MyButton b = new MyButton("Get Java3D...");
               b.addActionListener(this);
               Panel pxx = new Panel();
               pxx.add(b);
               pxx.add(bHowToInstJar);
               px.add("South", pxx);

               p.setContent(px);
               break;
           } case 5: {
               Panel px = new Panel();
               px.setLayout(new GridLayout(2,1));
               l.setText("Congratulations!  You have finished setting up your computer to run the Periodic Table!  Click \"Next\" and you will be directed to the Periodic Table.");
               px.add(l);
               px.add(ckHavePlugin);
               p.setContent(px);
               break;
           } case 6: {
               //let's try to form a url...
               // ../j11/ has the Standard version
               // ../j12/ has the Optimized version
               // ../j123d/ has the 3D version

               StringBuffer Earl = new StringBuffer("../");

               switch (iInstallOption) {
                   case 1: Earl.append("j11/");break;
                   case 2: Earl.append("j12/");break;
                   case 3: Earl.append("j123d/");break;
               }

               if(ckHavePlugin.getState()) {
                   Earl.append("plugin.html");
               } else {
                   Earl.append("regular.html");
               }

             try {
               if(p.isApp) {
                   Runtime r = Runtime.getRuntime();
                   r.exec("start "+Earl.toString());
               } else {
                   AppletContext ac = getAppletContext();
                   ac.showDocument(new URL(getCodeBase()+Earl.toString()), "_self");
               }
             } catch (Exception ex) {
               System.err.println("Could not open the Periodic Table page.");
               ex.printStackTrace(); 
             }
           }
       }
   }

   public void onCancel() {
       if(isApp) fm.dispose();
       if(!noExit) System.exit(0);
   }

   public void actionPerformed(ActionEvent e) {
       Object o = e.getSource();
       if(o instanceof MyButton) {
           MyButton b = (MyButton)o;
           String x = b.getLabel();
           if(x.equals("Get Java Plugin...")) {
             try {
               if(p.isApp) {
                   Runtime r = Runtime.getRuntime();
                   r.exec("start http://www.javasoft.com/products/plugin/");
               } else {
                   AppletContext ac = getAppletContext();
                   ac.showDocument(new URL("http://www.javasoft.com/products/plugin/"), "_blank");
               }
             } catch (Exception ex) {
               System.err.println("Could not open the Java Plugin page.");
             }
           } else if(x.equals("How to install a JAR")) {
               InstallJar ij = new InstallJar();
               String s[] = {"YouAreNotTheMainWindow"};
               ij.main(s);
           } else if(x.equals("Go to Java vendor...")) {
             try {
               if(p.isApp) {
                   Runtime r = Runtime.getRuntime();
                   r.exec("start "+System.getProperty("java.vendor.url"));
               } else {
                   AppletContext ac = getAppletContext();
                   ac.showDocument(new URL(System.getProperty("java.vendor.url")), "_blank");
               }
             } catch (Exception ex) {
               System.err.println("Could not open the Java vendor's page.");
             }
           } else if(x.equals("Get Java3D...")) {
             try {
               if(p.isApp) {
                   Runtime r = Runtime.getRuntime();
                   r.exec("start http://www.javasoft.com/products/java-media/3D/index.html");
               } else {
                   AppletContext ac = getAppletContext();
                   ac.showDocument(new URL("http://www.javasoft.com/products/java-media/3D/index.html"), "_blank");
               }
             } catch (Exception ex) {
               System.err.println("Could not open the Java3D page.");
             }
           } else if(x.equals("Get Swing...")) {
             try {
               if(p.isApp) {
                   Runtime r = Runtime.getRuntime();
                   r.exec("start http://www.javasoft.com/products/jfc/");
               } else {
                   AppletContext ac = getAppletContext();
                   ac.showDocument(new URL("http://www.javasoft.com/products/jfc/"), "_blank");
               }
             } catch (Exception ex) {
               System.err.println("Could not open the Swing page.");
             }
           }
       }
   }

   private final static String welcome =
       "Welcome to the Periodic Table '99 install program.  Needless to say, this program helps set it up.\n"+
       "\n"+
       "It is strongly recommended that you exit all other programs before running this installer.\n"+
       "\n"+
       "Click \"Next\" to continue with the install program.\n"+
       "\n"+
       "\n"+
       "WARNING: Copyright laws and international treaties protect this program.\n"+
       "\n"+
       "Unauthorized reproduction or distribution of this program, or any portion of it, may result in severe civil and criminal penalties and will be prosecuted to the maximum extend possible under the law.";
       //System.getProperty("java.vendor.url")
   public Frame fm;
   public boolean noExit = false;

   public static void main(String args[]) {
       Frame f = new Frame(name);
       f.setBackground(Color.lightGray);
       f.setLayout(new BorderLayout());

       try {
           f.setVisible(true);
       } catch (NoSuchMethodError e) {
           System.err.println("You must have Java 1.1 to install this program!");
           return;
       }

       Dimension s = new Dimension(586, 393);
       f.setSize(s);
       Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
       f.setLocation((d.width-s.width)/2, (d.height-s.height)/2);

       MainInstaller i = new MainInstaller();
       i.isApp = true;
       i.fm = f;
       if(args.length > 0) {
           if(args[0].equals("YouAreNotTheMainWindow")) i.noExit = true;
       }
       f.addWindowListener(i);
       f.add("Center", i);
       i.init();

       f.setTitle(i.name + " Installer");
       f.doLayout();
   }

//   public MainInstaller() {}

   public void init() {
       setBackground(Color.lightGray);
       p = new Wizard(isApp, this);
       setLayout(new BorderLayout());
       add("Center", p);
       p.invalidate();
       validate();
       bHowToInstJar.addActionListener(this);

       sJavaVer = System.getProperty("java.version");
       setPage(0, true);
   }
   //WindowListener
   public void windowActivated(WindowEvent e) {}
   public void windowDeactivated(WindowEvent e) {}
   public void windowIconified(WindowEvent e) {}
   public void windowDeiconified(WindowEvent e) {}
   public void windowOpened(WindowEvent e) {}
   public void windowClosed(WindowEvent e) {}
   public void windowClosing(WindowEvent e) {onCancel();}
}
