import javax.swing.*;
import javax.swing.border.*;
import java.awt.image.*;
import java.awt.*;

public class ImageLoadStatusManager extends JWindow implements ImageObserver, LoadStatusManager {
   Image splashIm;
   JLabel s;
   JLabel l;
   JProgressBar p;
   int iCalls = 0;

   public boolean imageUpdate(Image img, int infoflags, int x,  int y, int width, int height) {
       resetSize();
       return true;
   }

   public void setMaximum(int n) {p.setMaximum(n);}
   public int getMaximum() {return p.getMaximum();}

	public static ImageLoadStatusManager getImageLoadStatusManager(String sImgName) {
       return getImageLoadStatusManager(new JFrame(), sImgName);
   }

	public static ImageLoadStatusManager getImageLoadStatusManager(Frame f, String sImgName) {
       MediaTracker mt = new MediaTracker(f);
       Image s = Toolkit.getDefaultToolkit().getImage(sImgName);
       mt.addImage(s,0);
       try {
          mt.waitForID(0);
       } catch(InterruptedException ie){}

       return new ImageLoadStatusManager(f, s);
   }

	public ImageLoadStatusManager(Image i) {
  		this(new JFrame(), i);
   }

   public ImageLoadStatusManager(Frame parent, Image splashIm) {
       super(parent);

       this.splashIm = splashIm;
       setBackground(Color.white);

       Container c = getContentPane();
       c.setLayout(new BorderLayout());

       l = new JLabel("Creating Property Panels...", SwingConstants.CENTER);
       l.setForeground(Color.red);

       s = new JLabel(new ImageIcon(splashIm));
       c.add("Center", s);
       s.add(l);
       l.setBounds(20,300,230,20);

       p = new JProgressBar(0, 100);
       s.add(p);
       p.setBounds(20,324,230,20);
       p.setValue(33);
       p.setStringPainted(true);
       p.setForeground(Color.red);
       p.setBackground(Color.black);
       p.setBorder(new javax.swing.border.LineBorder(Color.white, 1));
       resetSize();
   }

   private void resetSize() {
       if(splashIm.getWidth(this) < 0) return;

       Dimension imgSize = new Dimension(splashIm.getWidth(this)+2, splashIm.getHeight(this)+2);
       setSize(imgSize);
/*       Dimension canvasSize = s.getSize();
       Dimension windowSize = getSize();

       Dimension e = new Dimension(
           windowSize.width+(canvasSize.width-canvasSize.width),
           windowSize.height+(canvasSize.height-canvasSize.height)
       );
       setSize(e);*/

       Dimension b = Toolkit.getDefaultToolkit().getScreenSize();
       Dimension d = getSize();
//       System.out.println(d.width+","+d.height);

       setLocation((b.width - d.width) / 2, (b.height - d.height) / 2);

       setVisible(true);
   }

   public void setProgressNum(int i) {
       setVisible(true);
       doLayout();
       iCalls = i;
       p.setValue(i);
   }

   public int getProgressNum() {
       return p.getValue();
   }

   public void setProgressText(String s) {
       setVisible(true);
       doLayout();
       l.setText(s);
   }

   public String getProgressText() {
   	return l.getText();
   }

   public void setProgress(String s) {
       setVisible(true);
       doLayout();
       p.setValue(iCalls++);
       l.setText(s);
//       try{Thread.sleep(1000);}catch(Exception e){}
   }

   public void setProgress(String s, int i) {
       setVisible(true);
       doLayout();
       iCalls = i;
       p.setValue(i);
       l.setText(s);
   }

   public void setVisible(boolean b) {super.setVisible(b);}
   public void dispose() {super.dispose();}      
}
