import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class MainWindow extends JFrame implements WindowListener {
   //WindowListener
   public void windowActivated(WindowEvent e) {}
   public void windowDeactivated(WindowEvent e) {}
   public void windowIconified(WindowEvent e) {}
   public void windowDeiconified(WindowEvent e) {}
   public void windowOpened(WindowEvent e) {}
   public void windowClosed(WindowEvent e) {}
   public void windowClosing(WindowEvent e) {
       System.exit(0);
   }

   public static void main(String args[]) {
       MainWindow mw = new MainWindow();
       mw.show();
   }

   private static final String menus[] = {"File", "Colors", "Graph", "Help"};
   private static final String file[] = {"Save Element", "Save All", "Save Database", "Print", "Exit"};
   private static final String colors[] = {"Color", "Monochrome"};
   private static final String graph[] = {"Interpolate Missing Points", "Draw Locator", "Locator Follows Curve", "Opaque Coordinates", "Table on Main Window", "Property List on Main Window"};
   private static final String help[] = {"About"};

   public MainWindow() {
       this("JPeriod99 test");
   }

   public MainWindow(String title) {
       super(title);
       addWindowListener(this);
       setSize(new Dimension(832, 624));

       IOManager iomgr = new IOManager(true, "");

       Container mainPanel = getContentPane();
       mainPanel.setLayout(new BorderLayout());

       JMenuBar mb = new JMenuBar();
       int i = 0;
       JCoolMenu cm = new JCoolMenu(menus[0]);
       for(i=0;i<file.length;i++) cm.add(new JMenuItem(file[i]));
       mb.add(cm);
       cm = new JCoolMenu(menus[1]);
       for(i=0;i<colors.length;i++) cm.add(new JMenuItem(colors[i]));
       mb.add(cm);
       cm = new JCoolMenu(menus[2]);
       for(i=0;i<graph.length;i++) cm.add(new JMenuItem(graph[i]));
       mb.add(cm);
       cm = new JCoolMenu(menus[3]);
       for(i=0;i<help.length;i++) cm.add(new JMenuItem(help[i]));
       mb.add(cm);
       
       JToolBar tbMenu = new JToolBar();
       mb.setBorder(null);
       tbMenu.setLayout(new BorderLayout());
       tbMenu.add("Center", mb);
       mainPanel.add("North", tbMenu);

       JLabel att = new JLabel("Atom Table");
//       JTextField att = new JTextField("Atom Table");
       JLabel pc = new JLabel("Panel Container");
       JSplitPane sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true, pc, att);

       sp.setBorder(null);
       sp.setOneTouchExpandable(true);

       JPanel p = new JPanel();
       p.setLayout(new BorderLayout());
       p.add("Center", sp);

       JTree t = new JTree();
       JScrollPane spp = new JScrollPane(t);
       JSplitPane sp2 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, spp, p);
       sp2.setBorder(null);
       sp2.setOneTouchExpandable(true);

       mainPanel.add("Center", sp2);

       ImageIcon ii[] = new ImageIcon[2];
       try {
           ii[0] = new ImageIcon(iomgr.getFile("print.jpg"));
           ii[1] = new ImageIcon(iomgr.getFile("save.jpg"));
       } catch (Exception e){
       }
       String ss[] = {"print", "save"};

       StatusBar sb = new StatusBar("Hello", ii, ss);
       mainPanel.add("South", sb);
       sb.setIconVisibility(0, false);
   }
}