/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BodyMeasurement
extends JPanel
implements IPanelListener,
ActionListener,
ItemListener {
    private float multiplier = 0.0f;
    private JTextField eInput = new JTextField("0.0", 8);
    private JComboBox cbUnits;
    private JTextField eOutput = new JTextField("0.0", 8);
    private JButton bCalc = new JButton("Calculate");
    private Hashtable elements;
    private JLabel l1 = new JLabel("For every");
    private JLabel l2 = new JLabel("you weigh, there are");
    private JLabel l3 = new JLabel("g of this element in your body.");
    private JLabel lCaption = new JLabel("How much of this element in your body?");
    private JPanel pControls = new JPanel();
    private JPanel pLabel = new JPanel();

    public String toString() {
        return "Body Measurement";
    }

    public BodyMeasurement() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("kg");
        defaultComboBoxModel.addElement("lbs");
        this.cbUnits = new JComboBox(defaultComboBoxModel);
        this.pControls.setLayout(new FlowLayout(1));
        this.pControls.add(this.l1);
        this.pControls.add(this.eInput);
        this.pControls.add(this.cbUnits);
        this.pControls.add(this.l2);
        this.pControls.add(this.eOutput);
        this.pControls.add(this.l3);
        this.pControls.add(this.bCalc);
        this.eOutput.setEditable(false);
        this.eOutput.setBackground(this.getBackground());
        this.bCalc.addActionListener(this);
        this.cbUnits.addItemListener(this);
        this.setLayout(new BorderLayout());
        Font font = this.lCaption.getFont();
        this.lCaption.setFont(new Font(font.getName(), font.getStyle(), 20));
        this.add("North", this.lCaption);
        this.add("Center", this.pControls);
    }

    public void setAtom(PanelEvent panelEvent) {
        this.multiplier = panelEvent.getElement().gperkg;
        this.calculate();
    }

    private void calculate() {
        float f;
        try {
            f = Float.valueOf(this.eInput.getText()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "You must enter a number for your body weight.", "Bad number format!", 0);
            return;
        }
        if ((double)f < 0.0) {
            JOptionPane.showMessageDialog(null, "Negative body weight is not possible.", "Bad number!", 0);
            return;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.cbUnits.getModel();
        int n = defaultComboBoxModel.getIndexOf(defaultComboBoxModel.getSelectedItem());
        if (n == 1) {
            f = (float)((double)f / 2.2046);
        }
        this.eOutput.setText(Float.toString(f * this.multiplier));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.calculate();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.calculate();
    }

    public void onActivate(PanelEvent panelEvent) {
    }

    public void onDeactivate(PanelEvent panelEvent) {
    }

    public void setStyle(PanelEvent panelEvent) {
    }
}

