/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class DatabaseManager {
    private IOManager iomgr;
    public static final String ElementsDB = "Elements.dat";
    public static final String EnthalpyDB = "Enthalpy.dat";
    public static final String LayoutDB = "Layout.dat";
    public static final String ClassesDB = "Class.dat";
    public static final String StatesDB = "State.dat";
    public static final String TypesDB = "Types.dat";
    private Hashtable elements;
    private Vector layout;
    private Hashtable classes;
    private Hashtable states;
    private Hashtable types;
    private LoadStatusManager lsmgr;
    private ConfigManager cfgmgr;

    public final Hashtable getElements() {
        return this.elements;
    }

    public final Vector getLayout() {
        return this.layout;
    }

    public final Hashtable getClasses() {
        return this.classes;
    }

    public final Hashtable getStates() {
        return this.states;
    }

    public final Hashtable getTypes() {
        return this.types;
    }

    public TElement getElement(int n) {
        return (TElement)this.elements.get(new Integer(n));
    }

    public DatabaseManager(LoadStatusManager loadStatusManager, IOManager iOManager, ConfigManager configManager) {
        this.iomgr = iOManager;
        this.lsmgr = loadStatusManager;
        this.cfgmgr = configManager;
        try {
            loadStatusManager.setProgress("Reading atomic database...");
            this.elements = this.getElements(this.iomgr.getInputStream(ElementsDB), this.iomgr.getInputStream(EnthalpyDB));
            loadStatusManager.setProgress("Reading table layout...");
            this.layout = this.getLayout(this.iomgr.getInputStream(LayoutDB));
            loadStatusManager.setProgress("Reading classes...");
            this.classes = this.getClasses(this.iomgr.getInputStream(ClassesDB));
            loadStatusManager.setProgress("Reading states...");
            this.states = this.getStates(this.iomgr.getInputStream(StatesDB));
            loadStatusManager.setProgress("Reading element types...");
            this.types = this.getTypes(this.iomgr.getInputStream(TypesDB));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable getElements(InputStream inputStream, InputStream inputStream2) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
        Hashtable<Integer, TElement> hashtable = new Hashtable<Integer, TElement>();
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        int n = stringTokenizer.countTokens();
        bufferedReader2.readLine();
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (++n2 % 10 == 0) {
                this.lsmgr.setProgress("Reading element " + n2 + "...");
            }
            TElement tElement = TElement.decode(string, n);
            tElement.enthalpies = this.decodeEnthalpies(bufferedReader2.readLine());
            hashtable.put(new Integer(tElement.AtomicNumber), tElement);
        }
        inputStream.close();
        inputStream2.close();
        return hashtable;
    }

    private Vector getLayout(InputStream inputStream) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Vector<String> vector = new Vector<String>(120);
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        vector.addElement(stringTokenizer.nextToken());
        vector.addElement(stringTokenizer.nextToken());
        while ((string = bufferedReader.readLine()) != null) {
            stringTokenizer = new StringTokenizer(string, "\t", false);
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        inputStream.close();
        return vector;
    }

    private float[] decodeEnthalpies(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        stringTokenizer.nextToken();
        int n = stringTokenizer.countTokens();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        }
        return fArray;
    }

    private Hashtable getClasses(InputStream inputStream) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Hashtable<Integer, TClass> hashtable = new Hashtable<Integer, TClass>();
        bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            TClass tClass = TClass.decode(string);
            hashtable.put(new Integer(tClass.number), tClass);
        }
        inputStream.close();
        return hashtable;
    }

    private Hashtable getStates(InputStream inputStream) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Hashtable<Integer, TState> hashtable = new Hashtable<Integer, TState>();
        bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            TState tState = TState.decode(string);
            hashtable.put(new Integer(tState.number), tState);
        }
        inputStream.close();
        return hashtable;
    }

    private Hashtable getTypes(InputStream inputStream) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Hashtable<Integer, TElementType> hashtable = new Hashtable<Integer, TElementType>();
        bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            TElementType tElementType = TElementType.decode(string);
            hashtable.put(new Integer(tElementType.number), tElementType);
        }
        inputStream.close();
        return hashtable;
    }

    public void saveEverything(DataOutputStream dataOutputStream) throws IOException {
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            dataOutputStream.writeBytes(AllElementInfo.getAtomInfoAsText((TElement)enumeration.nextElement(), this));
            dataOutputStream.writeBytes(this.cfgmgr.getCrlf());
            dataOutputStream.writeBytes(this.cfgmgr.getCrlf());
            dataOutputStream.writeBytes("======================================");
            dataOutputStream.writeBytes(this.cfgmgr.getCrlf());
            dataOutputStream.writeBytes(this.cfgmgr.getCrlf());
        }
    }
}

