import javax.swing.*;
import java.io.*;
import java.awt.*;

public class StatusKeeper {
	private JProgressBar progress;
	private JLabel status;
	private boolean enabled = true;
	private Window parent;
	private DataOutputStream os = null;


	public StatusKeeper(JProgressBar p, JLabel s, boolean e, Window a){
		progress = p;
		enabled = e;
		status = s;
		parent = a;
	}

	public void setDumpFile(DataOutputStream o) {os = o;}

	public void hideWindow() {parent.setVisible(false);}
	public void showWindow() {parent.setVisible(true);}

	public boolean getEnabled() { return enabled; }
	public void setEnabled(boolean x) {enabled = x;}

	public void showProgressBar() {
		if(!enabled) return;
		if(progress == null) return;
		progress.setVisible(true);
		if(progress.getParent() == null) return;
		progress.getParent().doLayout();
	}

	public void setProgressText(String s, int x) {
		if(!enabled) return;
		setStatus(s);
		setProgress(x);
		progress.getParent().doLayout();
	}

	public void setMax(int x) {
		if(!enabled) return;
		if(progress != null)
			progress.setMaximum(x);
	}

	public void initProgressBar() {
		if(!enabled) return;
		if(progress == null) return;
		progress.setMinimum(0);
		progress.setValue(0);
	}

	public void hideProgressBar() {
		if(!enabled) return;
		if(progress == null) return;
		progress.setVisible(false);
		if(progress.getParent() == null) return;
		progress.getParent().doLayout();
	}

	public void setStatus(String s) {
	  try {
		if(!enabled) return;
		if(status == null) return;
		status.setText(s);
		if(status.getParent() == null) return;
		status.repaint();
		if(os != null){
			os.writeBytes(s+"\r\n");
			os.flush();
		}
	  } catch (IOException e) {e.printStackTrace();}
	}

	public void setProgress(int p){
	  try {
		if(!enabled) return;
		if(progress == null) return;
		progress.setValue(p);
		progress.repaint();
		if(os != null){
			os.writeBytes("Progress at "+p+" of "+progress.getMaximum()+"\r\n");
			os.flush();
		}
	  } catch (IOException e) {e.printStackTrace();}
	}
}
