/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class TreeSaver
implements Runnable {
    String fname;
    JTree tTree;
    DefaultTreeModel tmModel;
    StatusKeeper stats;
    private int Count;
    private int Saved;

    public void run() {
        while (true) {
            this.stats.setProgress(this.Saved);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void saveNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.DoExportCount(defaultMutableTreeNode);
        this.stats.setEnabled(true);
        this.stats.setMax(this.Count);
        this.stats.initProgressBar();
        this.stats.showProgressBar();
        this.stats.setStatus("Saving disassembly to \"" + this.fname + "\"...");
        this.DoExport(defaultMutableTreeNode);
        this.stats.hideProgressBar();
        this.stats.setStatus("Saved disassembly to \"" + this.fname + "\"...");
    }

    public void saveRoot() {
        this.DoRootExportCount();
        this.stats.setEnabled(true);
        this.stats.setMax(this.Count);
        this.stats.initProgressBar();
        this.stats.showProgressBar();
        this.stats.setStatus("Saving disassembly to \"" + this.fname + "\"...");
        this.DoRootExport();
        this.stats.hideProgressBar();
        this.stats.setStatus("Saved disassembly to \"" + this.fname + "\"...");
    }

    private final void DoExport(DefaultMutableTreeNode defaultMutableTreeNode) {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fname);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            this.DumpNode(defaultMutableTreeNode, dataOutputStream);
            dataOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        thread.interrupt();
        thread = null;
    }

    private final void DoRootExport() {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        try {
            DefaultMutableTreeNode defaultMutableTreeNode;
            FileOutputStream fileOutputStream = new FileOutputStream(this.fname);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.tmModel.getRoot();
            this.DumpNode(defaultMutableTreeNode2, dataOutputStream);
            while ((defaultMutableTreeNode = defaultMutableTreeNode2.getNextSibling()) != null) {
                this.DumpNode(defaultMutableTreeNode, dataOutputStream);
            }
            dataOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        thread.interrupt();
        thread = null;
    }

    private final void DumpNode(DefaultMutableTreeNode defaultMutableTreeNode, DataOutputStream dataOutputStream) throws IOException {
        int n = defaultMutableTreeNode.getLevel();
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeBytes("  |");
            ++n2;
        }
        dataOutputStream.writeBytes("--");
        String string = defaultMutableTreeNode.toString();
        dataOutputStream.writeBytes(string);
        dataOutputStream.writeBytes("\r\n");
        ++this.Saved;
        if (defaultMutableTreeNode.getChildCount() == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        do {
            if (defaultMutableTreeNode2.getChildCount() > 0) {
                this.DumpNode(defaultMutableTreeNode2, dataOutputStream);
                continue;
            }
            n = defaultMutableTreeNode2.getLevel();
            int n3 = 0;
            while (n3 < n) {
                dataOutputStream.writeBytes("  |");
                ++n3;
            }
            dataOutputStream.writeBytes("--");
            string = defaultMutableTreeNode2.toString();
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeBytes("\r\n");
            ++this.Saved;
        } while ((defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAfter(defaultMutableTreeNode2)) != null);
    }

    private final void DoRootExportCount() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        this.Count = 0;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.tmModel.getRoot();
        this.DumpNodeCount(defaultMutableTreeNode2);
        while ((defaultMutableTreeNode = defaultMutableTreeNode2.getNextSibling()) != null) {
            this.DumpNodeCount(defaultMutableTreeNode);
        }
    }

    private final void DoExportCount(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.Count = 0;
        this.DumpNodeCount(defaultMutableTreeNode);
    }

    private final void DumpNodeCount(DefaultMutableTreeNode defaultMutableTreeNode) {
        ++this.Count;
        if (defaultMutableTreeNode.getChildCount() == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        do {
            if (defaultMutableTreeNode2.getChildCount() > 0) {
                this.DumpNodeCount(defaultMutableTreeNode2);
                continue;
            }
            ++this.Count;
        } while ((defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAfter(defaultMutableTreeNode2)) != null);
    }

    public TreeSaver(String string, JTree jTree, StatusKeeper statusKeeper) {
        this.fname = string;
        this.tTree = jTree;
        this.stats = statusKeeper;
        this.tmModel = (DefaultTreeModel)this.tTree.getModel();
    }
}

