/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.SystemColor;

class StatusBar
extends Panel {
    private String msg;
    private Font font;
    private int myHeight;

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.height = this.myHeight;
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.myHeight;
        return dimension;
    }

    public String getText() {
        return this.msg;
    }

    public void setText(String string) {
        this.msg = string;
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public void update(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Color color = graphics.getColor();
        graphics.setColor(SystemColor.control);
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        graphics.setColor(color);
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        graphics.drawString(this.msg, 2, (this.myHeight - this.font.getSize()) / 2 + this.font.getSize() - 1);
        graphics.setFont(font);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public StatusBar(String string, Font font, int n) {
        this.msg = string;
        this.font = font;
        this.myHeight = n;
        this.repaint();
        this.setBackground(Color.lightGray);
    }

    public StatusBar(String string, Font font) {
        this(string, font, 22);
    }

    public StatusBar(String string) {
        this(string, new Font("Dialog", 0, 13), 22);
    }

    public StatusBar() {
        this("", new Font("Dialog", 0, 13), 22);
    }
}

