/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

class MethodInfo
implements ElementInfo {
    int count;
    ConstantPoolInfo constants;
    MethodItem[] methods;
    StatusKeeper stats;

    public DefaultMutableTreeNode Describe() {
        this.stats.initProgressBar();
        this.stats.setMax(this.count);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Methods: " + this.count + " items.");
        int n = 0;
        while (n < this.count) {
            defaultMutableTreeNode.add(this.methods[n].Describe());
            ++n;
        }
        return defaultMutableTreeNode;
    }

    public MethodInfo(ConstantPoolInfo constantPoolInfo, DataInputStream dataInputStream, StatusKeeper statusKeeper) {
        try {
            this.stats = statusKeeper;
            this.constants = constantPoolInfo;
            this.count = dataInputStream.readUnsignedShort();
            if (this.count != 0) {
                this.methods = new MethodItem[this.count];
                int n = 0;
                while (n < this.count) {
                    this.methods[n] = new MethodItem(constantPoolInfo, dataInputStream, n, this.stats);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("" + iOException);
        }
    }
}

