/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

class FieldItem
implements ElementInfo {
    int access_flags;
    int name_index;
    String name;
    int signature_index;
    ConstantPoolInfo constants;
    AttributeInfo attributes;
    StatusKeeper stats;
    int num;

    public DefaultMutableTreeNode Describe() {
        this.stats.setProgressText("Processing field \"" + this.name + "\"...", this.num);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.name);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.constants.getUtf8(this.signature_index)));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(ClassReader.listAccessFlags(this.access_flags)));
        defaultMutableTreeNode.add(this.attributes.Describe());
        return defaultMutableTreeNode;
    }

    public FieldItem(ConstantPoolInfo constantPoolInfo, DataInputStream dataInputStream, StatusKeeper statusKeeper, int n) {
        try {
            this.num = n;
            this.stats = statusKeeper;
            this.constants = constantPoolInfo;
            this.access_flags = dataInputStream.readUnsignedShort();
            this.name_index = dataInputStream.readUnsignedShort();
            this.name = constantPoolInfo.getUtf8(this.name_index);
            this.signature_index = dataInputStream.readUnsignedShort();
            this.attributes = new AttributeInfo(constantPoolInfo, dataInputStream);
        }
        catch (IOException iOException) {
            System.out.println("" + iOException);
        }
    }
}

