/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

public class ConstantPoolInfo
implements ElementInfo {
    private int count;
    private PoolItem[] constants;
    private StatusKeeper stats;

    public DefaultMutableTreeNode Describe() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Constant Pool: " + this.count + " items.");
        int n = 1;
        while (n < this.count) {
            if (this.constants[n] != null) {
                switch (this.constants[n].tag) {
                    case 7: {
                        defaultMutableTreeNode.add(((Class_info)this.constants[n]).Describe());
                        break;
                    }
                    case 9: {
                        defaultMutableTreeNode.add(((Fieldref_info)this.constants[n]).Describe());
                        break;
                    }
                    case 10: {
                        defaultMutableTreeNode.add(((Methodref_info)this.constants[n]).Describe());
                        break;
                    }
                    case 8: {
                        defaultMutableTreeNode.add(((String_info)this.constants[n]).Describe());
                        break;
                    }
                    case 3: {
                        defaultMutableTreeNode.add(((Integer_info)this.constants[n]).Describe());
                        break;
                    }
                    case 4: {
                        defaultMutableTreeNode.add(((Float_info)this.constants[n]).Describe());
                        break;
                    }
                    case 5: {
                        defaultMutableTreeNode.add(((Long_info)this.constants[n]).Describe());
                        break;
                    }
                    case 6: {
                        defaultMutableTreeNode.add(((Double_info)this.constants[n]).Describe());
                        break;
                    }
                    case 11: {
                        defaultMutableTreeNode.add(((IMethodref_info)this.constants[n]).Describe());
                        break;
                    }
                    case 12: {
                        defaultMutableTreeNode.add(((NameAndType_info)this.constants[n]).Describe());
                        break;
                    }
                    case 1: {
                        defaultMutableTreeNode.add(((Utf8_info)this.constants[n]).Describe());
                        break;
                    }
                    case 2: {
                        defaultMutableTreeNode.add(((Unicode_info)this.constants[n]).Describe());
                        break;
                    }
                    default: {
                        defaultMutableTreeNode.add(this.constants[n].Describe());
                    }
                }
            }
            ++n;
        }
        return defaultMutableTreeNode;
    }

    public String getUtf8(int n) {
        if (n < this.constants.length) {
            return this.constants[n].getUtf8();
        }
        return "";
    }

    public String describe(int n) {
        if (n < this.constants.length) {
            return this.constants[n].toString();
        }
        return "Invalid Index";
    }

    public String getName(int n) {
        if (n < this.constants.length) {
            return this.constants[n].getName();
        }
        return "InvalidIndex";
    }

    public String getSignature(int n) {
        if (n < this.constants.length) {
            return this.constants[n].getSignature();
        }
        return "InvalidIndex";
    }

    public ConstantPoolInfo(DataInputStream dataInputStream, StatusKeeper statusKeeper) throws IOException {
        this.stats = statusKeeper;
        this.count = dataInputStream.readUnsignedShort();
        this.constants = new PoolItem[this.count];
        this.stats.initProgressBar();
        this.stats.setMax(this.count);
        int n = 1;
        while (n < this.count) {
            this.constants[n] = PoolItem.pullPoolItem(this, dataInputStream, this.stats, n);
            if (!this.constants[n].resolved) break;
            if (this.constants[n].isDoubleWide()) {
                ++n;
            }
            ++n;
        }
    }
}

