package grid.worker;

import javax.swing.table.AbstractTableModel;
import java.util.List;

public class WorkerTableModel extends AbstractTableModel {
	private List workerList;

	public WorkerTableModel(List workerList) {
		this.workerList = workerList;
	}

	public int getRowCount() {
		return workerList.size();
	}

	public int getColumnCount() {
		return 3;
	}

	private static String states[] = {
		"Connecting",
		"Disconnected",
		"Waiting",
		"Running"
	};

	public Object getValueAt(int row, int column) {
		Worker w = (Worker)workerList.get(row);
		switch(column) {
			case 0:
				return w.getRegistry();
			case 1:
				return states[w.getStatus()];
			case 2:
				String x = w.getTaskProgress();
				return w.getTaskID() + (x != null ? " ("+x+")" : "");
			default:
				return "?";
		}
	}

	private static String columns[] = {
		"Server",
		"Status",
		"Task"
	};

	public String getColumnName(int column) {
		return columns[column];
	}
}
