package grid.worker;

import grid.util.Defaults;
import grid.util.LocalProperties;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JSpinner;
import javax.swing.JButton;
import javax.swing.JLabel;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerNumberModel;
import java.util.List;
import java.util.LinkedList;

public class AddWorkerDialog extends JDialog {
	private JTextField serverLine;
	private JSpinner workersLine;
	private JButton addButton, cancelButton;

	private boolean finished;

	public List getWorker() {
		if(!finished) return null;

		int x = ((Integer)workersLine.getValue()).intValue();
		List w = new LinkedList();
		for(int i=0;i<x;i++) {
			Worker y = new Worker(serverLine.getText());
			w.add(y);
			y.start();
		}
		return w;
	}

	public AddWorkerDialog(Frame parent) {
		super(parent, "Add a Worker");
		setModal(true);

		//init data
		finished = false;

		//init ui items
		serverLine = new JTextField(
			LocalProperties.getProperty("grid.worker.Worker.server",
				Defaults.server)
		);
		workersLine = new JSpinner();
		try {
			workersLine.setModel(
				new SpinnerNumberModel(
					Integer.parseInt(LocalProperties.getProperty("grid.worker.Worker.workers", Defaults.sWorkers)),
					1,
					32767,
					1
				)
			);
		} catch (Exception e) {
			workersLine.setModel(
				new SpinnerNumberModel(1, 1, 32767, 1)
			);
		}

		addButton = new JButton("Add");
		addButton.setDefaultCapable(true);
		addButton.setMnemonic('A');
		
		cancelButton = new JButton("Cancel");
		cancelButton.setMnemonic('C');

		//set up layout
		GridBagLayout gb = new GridBagLayout();
		getContentPane().setLayout(gb);
		GridBagConstraints c = new GridBagConstraints();

		c.insets = new Insets(10, 10, 10, 10);
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 0.0;
		c.gridx = 0;
		c.gridy = 0;
		JLabel l = new JLabel("Server:");
		gb.setConstraints(l, c);
		getContentPane().add(l);

		l = new JLabel("Workers:");
		c.gridy = 1;
		gb.setConstraints(l, c);
		getContentPane().add(l);

		c.gridx = 1;
		c.gridy = 0;
		c.weightx = 1.0;
		c.gridwidth = 2;
		gb.setConstraints(serverLine, c);
		getContentPane().add(serverLine);

		c.gridwidth = 1;
		c.gridy = 1;
		gb.setConstraints(workersLine, c);
		getContentPane().add(workersLine);

		c.gridx = 1;
		c.gridy = 2;
		gb.setConstraints(addButton, c);
		getContentPane().add(addButton);

		c.gridx = 2;
		gb.setConstraints(cancelButton, c);
		getContentPane().add(cancelButton);

		getRootPane().setDefaultButton(addButton);

		//set up events
		addButton.addActionListener(new AddButtonHandler(this));
		cancelButton.addActionListener(new CancelButtonHandler(this));

		//show
		pack();
		show();
	}
	
	class CancelButtonHandler implements ActionListener {
		private JDialog t;

		public CancelButtonHandler(JDialog t) {
			this.t = t;
		}

		public void actionPerformed(ActionEvent e) {
			finished = false;
			t.dispose();
		}
	}

	class AddButtonHandler implements ActionListener {
		private JDialog t;

		public AddButtonHandler(JDialog t) {
			this.t = t;
		}

		public void actionPerformed(ActionEvent e) {
			finished = true;
			t.dispose();
		}
	}
}

