package grid.util;

import java.util.Properties;

public class LocalProperties {
	private LocalProperties() {}

	private static Properties props = new Properties();

	public static String getProperty(String key, String defaul) {
		String x = props.getProperty(key);
		if(x == null) return System.getProperty(key, defaul);
		return x;
	}

	public static Object setProperty(String key, String value) {
		try {
			return System.setProperty(key, value);
		} catch (Exception e) {
			return props.setProperty(key, value);
		}
	}

	public static Object setLocalProperty(String key, String value) {
		return props.setProperty(key, value);
	}
}
