/*
 * @(#)MessageBox.java	1.1 98/11/09
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import java.awt.*;
import java.awt.event.*;

/**
 * Displays an error message or any other message, with the given title and
 * message
 */
public class MessageBox extends Dialog {

	public MessageBox(Frame parent, String title, String message) {
		super(parent, title, true);
		setLayout( new BorderLayout() );
   	setBackground(Color.lightGray);

		// Panel at the bottom with a flow layout to put an OK button
		Panel bottom = new Panel();
		bottom.setLayout( new FlowLayout() );
		Button ok = new Button("OK");
		ok.addActionListener( new ActionListener() {
	    	public void actionPerformed(ActionEvent ae) {
				dispose();
           }
       }
       );
		bottom.add(ok);

		// Add a message label.
		add("Center", new Label(message, Label.CENTER));
		// Add the panel with the button to the south
		add("South", bottom);
		// Frame requires explicit setVisible(true)
		pack();
       Dimension b = getSize(); Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
       setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);
//		setVisible(true);
	}

   public void addNotify() {
		super.addNotify();
//		pack();
   }
}
