import java.awt.*;
import java.awt.event.*;

public class Diotallevi extends Frame implements WindowListener, ActionListener {
	private static final Label[] labels = {
   	new Label("What is the seed file's name?"),
       new Label("Give me any arbitrary number"),
       new Label("What is the source file's name?"),
       new Label("What is the file to dump to?"),
       new Label("Do you have a header file to prepend?"),
       new Label("What is the header file's name?"),
       new Label("How many lines do you want?"),
       new Label("Do you have a footer file to append?"),
       new Label("What is the footer file's name?")
   };
   private static final Component[] ctls = {
   	new TextField(),
       new TextField("42"),
       new TextField(),
       new TextField(),
       new Checkbox("", false),
       new TextField(),
       new TextField("20"),
       new Checkbox("", false),
       new TextField()
   };
   private static final Component[] helpers = {
   	new Button("Browse..."),
       new Panel(),
       new Button("Browse..."),
       new Button("Browse..."),
       new Panel(),
       new Button("Browse..."),
       new Panel(),
       new Panel(),
       new Button("Browse...")
   };

   public void actionPerformed(ActionEvent e) {
   	String x = e.getActionCommand();
		if(x.equals("Engage!")) {
       	BabelInfo bi = new BabelInfo();
           bi.seed =                   ((TextField)ctls[0]).getText();
           bi.seed2 =    Long.valueOf( ((TextField)ctls[1]).getText() ).longValue();
           bi.source =                 ((TextField)ctls[2]).getText();
           bi.dump =                   ((TextField)ctls[3]).getText();
           bi.hasHeader =               ((Checkbox)ctls[4]).getState();
           bi.header =                 ((TextField)ctls[5]).getText();
           bi.numLines = Long.valueOf( ((TextField)ctls[6]).getText() ).longValue();
           bi.hasFooter =               ((Checkbox)ctls[7]).getState();
           bi.footer =                 ((TextField)ctls[8]).getText();

           try {
           	Babelizer.babelize(bi);
           } catch(Exception xe) {xe.printStackTrace();}
           MessageBox mb = new MessageBox(this, "Done Babelizing...", "Diotallevi is done!");
           mb.show();
       	return;
       }
       int i = Integer.valueOf(x).intValue();
      	TextField tf = (TextField)ctls[i];
       String fname = tf.getText();
       FileDialog fd = new FileDialog(this, "Choose a file...", FileDialog.LOAD);
       fd.setFile(fname);
       fd.show();
       if(fd.getFile() != null)
       	tf.setText(fd.getDirectory()+fd.getFile());
   }

   //WindowListener
   public void windowActivated(WindowEvent e) {}
   public void windowDeactivated(WindowEvent e) {}
   public void windowIconified(WindowEvent e) {}
   public void windowDeiconified(WindowEvent e) {}
   public void windowOpened(WindowEvent e) {}
   public void windowClosed(WindowEvent e) {}
   public void windowClosing(WindowEvent e) {System.exit(0);}

   public Diotallevi() {
   	super(name);
   	setBackground(Color.lightGray);
       Component c; Font f1, f2;

       GridLayout g = new GridLayout(10, 3);
       g.setVgap(10);
       g.setHgap(10);
		setLayout(g);

       for(int i=0;i<9;i++) {
       	add(labels[i]);

           add(ctls[i]);
           c = helpers[i];
           if(c instanceof Button) {
           	Button b = (Button)c;
           	b.addActionListener(this);
               b.setActionCommand(Integer.toString(i));
           }
           add(helpers[i]);
       }
       Label lx = new Label("Click \"Engage!\" when done -->");
       add(lx);
       Button bx = new Button("Engage!");
       bx.addActionListener(this);
       add(bx);
       setVisible(true);
       setSize(new Dimension(800, 600));
       Dimension b = getSize(); Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
       setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);
       addWindowListener(this);

       c = bx;
       f1 = c.getFont();
       f2 = new Font(f1.getFamily(), f1.getStyle(), 20);
       c.setFont(f2);
       c = lx;
       f1 = c.getFont();
       f2 = new Font(f1.getFamily(), f1.getStyle(), 18);
       c.setFont(f2);
      	for(int i=0;i<9;i++) {
       	c = labels[i];
       	f1 = c.getFont();
       	f2 = new Font(f1.getFamily(), f1.getStyle(), 18);
       	c.setFont(f2);

	      	c = helpers[i];
       	f1 = c.getFont();
       	f2 = new Font(f1.getFamily(), f1.getStyle(), 20);
       	c.setFont(f2);

       	c = ctls[i];
       	f1 = c.getFont();
       	f2 = new Font(f1.getFamily(), f1.getStyle(), 20);
       	c.setFont(f2);
       }

   }

   private static final String name = "Belbo's (Abu)se of Language, v4.2 * ln(22026.46579) by Ardenti.";

   public static void main(String[] args) {
   	System.out.println(name);
   	Diotallevi d = new Diotallevi();
   }
}
