import javax.swing.*;
import java.awt.event.*;
import javax.swing.table.*;
import java.awt.datatransfer.*;
import java.awt.*;

public class Zeff extends JScrollPane implements ActionListener, IPanelListener {
   private PropertyPanelManager ppmgr;
   private JTable j = new JTable();

   private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 'C');
   private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 'P');
   private JMenu pmContext = new JCoolMenu("Panel");

   public String toString() {return "Values for Zeff";}
   private TElement currSelection = null;

   public Zeff (ConfigManager cfgmgr, PropertyPanelManager pp){
       super();
       ppmgr = pp;

       Font f = j.getFont();
       j.setFont(new Font(f.getName(), 0, 20));
       j.setRowHeight(j.getRowHeight()+10);
       j.setSelectionMode(0);
       j.setCellSelectionEnabled(false);
       setViewportView(j);

       if(cfgmgr.canGetClipboard()) {
           miCopyToClipboard.addActionListener(this);
           miCopyToClipboard.setActionCommand("CopyToClipboard");
           pmContext.add(miCopyToClipboard);
       }

       if(cfgmgr.canPrint()) {
           miPrintGraph.addActionListener(this);
           miPrintGraph.setActionCommand("FilePrintText");
           pmContext.add(miPrintGraph);
       }
       pmContext.setMnemonic('P');
   }

   private static final String[] names = {"Orbital", "Zeff"};

   public void setAtom(PanelEvent pe){
       TElement elem = pe.getElement();

       Object[][] d = {
           {"1s", (elem.zeff_s1>0?Float.toString(elem.zeff_s1):"Unknown")},
           {"2s", (elem.zeff_s2>0?Float.toString(elem.zeff_s2):"Unknown")},
           {"2p", (elem.zeff_p2>0?Float.toString(elem.zeff_p2):"Unknown")},
           {"3s", (elem.zeff_s3>0?Float.toString(elem.zeff_s3):"Unknown")},
           {"3p", (elem.zeff_p3>0?Float.toString(elem.zeff_p3):"Unknown")},
           {"4s", (elem.zeff_s4>0?Float.toString(elem.zeff_s4):"Unknown")},
           {"4p", (elem.zeff_p4>0?Float.toString(elem.zeff_p4):"Unknown")},
           {"4d", (elem.zeff_d4>0?Float.toString(elem.zeff_d4):"Unknown")},
           {"4f", (elem.zeff_f4>0?Float.toString(elem.zeff_f4):"Unknown")},
           {"5s", (elem.zeff_s5>0?Float.toString(elem.zeff_s5):"Unknown")},
           {"5p", (elem.zeff_p5>0?Float.toString(elem.zeff_p5):"Unknown")},
           {"5d", (elem.zeff_d5>0?Float.toString(elem.zeff_d5):"Unknown")},
           {"6s", (elem.zeff_s6>0?Float.toString(elem.zeff_s6):"Unknown")},
           {"6p", (elem.zeff_p6>0?Float.toString(elem.zeff_p6):"Unknown")},
           {"7s", (elem.zeff_s7>0?Float.toString(elem.zeff_s7):"Unknown")}
       };

       DefaultTableModel dtm = new DefaultTableModel(d, names) {
           public boolean isCellEditable(int row, int col) {return false;}
       };

       j.setModel(dtm);
       j.repaint();
       currSelection = elem;
   }

   public void setStyle(int style) {}

   public void onActivate(PanelEvent pe) {
       ppmgr.addMenu(pmContext);
       j.invalidate();
       validate();
   }
   public void onDeactivate(PanelEvent pe) {
       ppmgr.removeMenu(pmContext);
   }

   public void actionPerformed(ActionEvent e){
       String s = e.getActionCommand();
       if(s.equals("CopyToClipboard")) {
           OnCopyToClipboard();
       } else if (s.equals("FilePrintText")) {
       	OnFilePrintText();
       }
   }

   private void OnCopyToClipboard() {
       StringSelection ss = new StringSelection(TElement.getZeff(currSelection));
       Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
       c.setContents(ss, ss);
   }

   private void OnFilePrintText() {
//       ItemPrinter ip = new ItemPrinter(this);
   }

   public void setStyle(PanelEvent pe) {}

   public void updateUI() {
       super.updateUI();
       if(pmContext != null) pmContext.updateUI();
   }
}
