import javax.swing.*;
import java.applet.*;
import java.io.*;
import javax.swing.border.*;
import javax.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;

public class JPeriod99 extends JFrame implements WindowListener {
   private Container mainPanel;
   private ConfigManager cfgmgr;
   private IOManager iomgr;
   private DatabaseManager dbmgr;
   private PropertyPanelManager ppmgr;
   private MenuManager menumgr;
   private StatusBar sb;

   private AtomicTable atomicTable;
   private JPanel tableHolder;
   private JFrame tableFrame;
   private BasicArrowButton tableButton;

   private JPanel host = new JPanel();

   private JTree jtPropertyTree = new JTree();
   private JScrollPane spPropertyTree;
   private JPanel treeHolder;
   private JFrame treeFrame;
   private BasicArrowButton treeButton;

   private JSplitPane sp, sp2;

   private boolean atomicTableOnForm = true;
   private boolean propertyTreeOnForm = true;

   //App init routines
   public static void main(String args[]) {
       realMain(true, "", null);
   }
   public static JPeriod99 realMain(boolean isApp, String codeBase, Applet applet) {
       try {
	        SecurityManager security = System.getSecurityManager();
	        if (security != null) {
	            security.checkPropertiesAccess();
	        }
           java.util.Properties p = System.getProperties();
           p.put("user.home", System.getProperty("user.dir"));

           p.put("swing.plaf.metal.controlFont", "Arial-bold-12");
           p.put("swing.plaf.metal.systemFont",  "Arial-bold-12");
           p.put("swing.plaf.metal.userFont",    "Arial-bold-12");
           p.put("swing.plaf.metal.smallFont",   "Arial-bold-10");

       } catch(SecurityException e) {;}

       JPeriod99 mw = new JPeriod99(isApp, codeBase, applet);
       mw.show();
       return mw;
   }

   //constructors
   protected JPeriod99(boolean isApp, String codeBase, Applet applet) {
       super("JPeriod99 -- a Periodic Table by Darrick Wong");
       addWindowListener(this);

       jtPropertyTree.putClientProperty("JTree.lineStyle", "Horizontal");
       jtPropertyTree.putClientProperty("JTree.lineStyle", "Angled");

       setProperWindowSize(); //3/4 screen, centered
       mainPanel = getContentPane();
       mainPanel.setLayout(new BorderLayout());

       //set up managers
       cfgmgr  = new ConfigManager(isApp, codeBase, applet);
       iomgr   = new IOManager(cfgmgr);

       LoadStatusManager lsmgr;
       try {
           lsmgr = new ImageLoadStatusManager(this, (new ImageIcon(iomgr.getFile("splash.jpg"))).getImage());
       } catch (Exception e) {
           lsmgr = new TextLoadStatusManager();
       }
       lsmgr.setMaximum(45);

       dbmgr   = new DatabaseManager(lsmgr, iomgr, cfgmgr);
       ppmgr   = new PropertyPanelManager(jtPropertyTree, dbmgr, host, this);
       menumgr = new MenuManager(lsmgr, cfgmgr, this, ppmgr);

       //Create the Tree
       lsmgr.setProgress("Creating property tree UI...");
       createTree();

       lsmgr.setProgress("Creating menus...");
//       mainPanel.add("North", menumgr.getMenuBar());
       setJMenuBar(menumgr.getMenuBar());

       //Make the status bar
       lsmgr.setProgress("Creating status bar...");
       sb = new StatusBar("Hello.");
       mainPanel.add("South", sb);

       //then add the table...
       lsmgr.setProgress("Creating table UI...");
       atomicTable = new AtomicTable(lsmgr, ppmgr, dbmgr, cfgmgr, this, sb);
       createTable();

       //and then the panel pane...
       lsmgr.setProgress("Creating panel backing...");
       createPanel();

       lsmgr.setProgress("Laying components...");
       layoutControls();

       (new PropertyPanelScript()).run(lsmgr, ppmgr, dbmgr, cfgmgr, sb);

       lsmgr.setProgress("Finishing...");
       //kill off the dialog!
       lsmgr.setVisible(false);
       lsmgr.dispose();

       try {
           ImageIcon ii = new ImageIcon( iomgr.getFile("dw.jpg") );
           Image im = ii.getImage();
           setIconImage(im);
       } catch (IOException e) {}

       System.runFinalization();
       System.gc();
       System.runFinalization();
   }

   private void setProperWindowSize() {
       Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
       setSize((d.width * 3) / 4, (d.height * 3) / 4);
       Dimension b = getSize();
       setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);
   }

   //WindowListener
   public void windowActivated(WindowEvent e) {}
   public void windowDeactivated(WindowEvent e) {}
   public void windowIconified(WindowEvent e) {}
   public void windowDeiconified(WindowEvent e) {}
   public void windowOpened(WindowEvent e) {}
   public void windowClosed(WindowEvent e) {}
   public void windowClosing(WindowEvent e) {
       Object o = e.getSource();
       if(o == this) {
           if(cfgmgr.canExitVM()) System.exit(0);
       } else if (o == treeFrame) {
           treeButton.doClick();
       } else if (o == tableFrame) {
           tableButton.doClick();       
       }
   }

   private void layoutControls() {
       Component cr;

       if(sp != null) mainPanel.remove(sp);
       if(sp2 != null) mainPanel.remove(sp2);       

       if(atomicTableOnForm) {
           sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT, false, tableHolder, host);
           sp.setBorder(null);
           sp.setOneTouchExpandable(true);
           cr = sp;
           atomicTable.invalidate();
       } else {
           cr = host;
       }

       Component cr2;
       if(propertyTreeOnForm) {
           sp2 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, false, treeHolder, cr);
           sp2.setBorder(null);
           sp2.setOneTouchExpandable(true);
           cr2 = sp2;
       } else {
           cr2 = cr;
       }
       mainPanel.add("Center", cr2);
   }

   public void toggleTreeOnForm(boolean set) {
       if(set) {
           //remove tree from frame
           Dimension d = treeHolder.getSize();
           treeFrame.setVisible(false);
           treeFrame.getContentPane().remove(treeHolder);
           //reset button
           treeButton.setDirection(SwingConstants.NORTH);
           propertyTreeOnForm = true;
           layoutControls();
           treeHolder.setPreferredSize(d);
           validate();
       } else {
           Dimension old = treeHolder.getSize();
           propertyTreeOnForm = false;
           layoutControls();
           treeButton.setDirection(SwingConstants.SOUTH);
           treeFrame.getContentPane().add("Center", treeHolder);
           treeFrame.setVisible(true);
           treeFrame.validate();
           validate();
           Dimension neww = treeHolder.getSize();
           Dimension frameSize = treeFrame.getSize();
           treeFrame.setSize(new Dimension(frameSize.width+(old.width-neww.width), frameSize.height+(old.height-neww.height)));
           treeFrame.validate();
       }
   }

   public void toggleTableOnForm(boolean set) {
       if(set) {
           //remove tree from frame
           Dimension d = tableHolder.getSize();
           tableFrame.setVisible(false);
           tableFrame.getContentPane().remove(tableHolder);
           //reset button
           tableButton.setDirection(SwingConstants.NORTH);
           atomicTableOnForm = true;
           layoutControls();
           tableHolder.setPreferredSize(d);
           validate();
       } else {
           Dimension old = tableHolder.getSize();
           atomicTableOnForm = false;
           layoutControls();
           tableButton.setDirection(SwingConstants.SOUTH);
           tableFrame.getContentPane().add("Center", tableHolder);
           tableFrame.setVisible(true);
           tableFrame.validate();
           validate();
           Dimension neww = tableHolder.getSize();
           Dimension frameSize = tableFrame.getSize();
           tableFrame.setSize(new Dimension(frameSize.width+(old.width-neww.width), frameSize.height+(old.height-neww.height)));
           tableFrame.validate();
       }
   }

   private void createTree() {
       spPropertyTree = new JScrollPane(jtPropertyTree);
       treeHolder = new JPanel();
       treeFrame = new JFrame("Property Tree");
       treeFrame.addWindowListener(this);
       treeFrame.getContentPane().setLayout(new BorderLayout());
       treeButton = new BasicArrowButton(SwingConstants.NORTH);
       treeButton.setActionCommand("PropTreeOnForm");
       treeButton.addActionListener(menumgr);
       JLabel treeLabel = new JLabel("Property Tree");
       JPanel treeLabelPanel = new JPanel();
       treeLabelPanel.setLayout(new BorderLayout());
       treeLabelPanel.add("Center", treeLabel);
       treeLabelPanel.add("East", treeButton);
       treeLabelPanel.setBorder(new EtchedBorder());
       treeHolder.setLayout(new BorderLayout());
       treeHolder.add("North", treeLabelPanel);
       treeHolder.add("Center", spPropertyTree);
   }

   private void createTable() {
       tableHolder = new JPanel();
       tableFrame = new JFrame("Atomic Table");
       tableFrame.addWindowListener(this);
       tableFrame.getContentPane().setLayout(new BorderLayout());
       tableButton = new BasicArrowButton(SwingConstants.NORTH);
       tableButton.setActionCommand("AtomicTableOnForm");
       tableButton.addActionListener(menumgr);
       JLabel tableLabel = new JLabel("Atomic Table");
       JPanel tableLabelPanel = new JPanel();
       tableLabelPanel.setLayout(new BorderLayout());
       tableLabelPanel.add("Center", tableLabel);
       tableLabelPanel.add("East", tableButton);
       tableLabelPanel.setBorder(new EtchedBorder());
       tableHolder.setLayout(new BorderLayout());
       tableHolder.add("North", tableLabelPanel);
       tableHolder.add("Center", atomicTable);
       atomicTable.setMinimumSize(new Dimension(320,240));
   }

   private void createPanel() {
       ElementName en = new ElementName();
       ppmgr.addProperty(en);
       host.setLayout(new BorderLayout());
       host.add("North", en);
   }

   public void OnHelpAbout() {
       Runtime r = Runtime.getRuntime();
       r.runFinalization();
       r.gc();
       r.runFinalization();       
       StringBuffer sb = new StringBuffer("JPeriod99 is an interactive Java-based Periodic Table.  \n");
       sb.append("Based on JavaSoft's Swing 1.1 technology, this program uses a whole lot of \n");
       sb.append("Swing components to create the table, a bunch of tabs to show you the graphs of \n");
       sb.append("various atomic properties.  This program needs at least Swing 1.1b3 and Java 1.1, \n");
       sb.append("but prefers Java 1.2. In fact, Java 1.2 users should see a performance boost over 1.1,\n");
       sb.append("as I have adapted the graphs to use the Java2D APIs over the standard AWT APIs.\n");
       sb.append("\n");
       sb.append("Last major rewrite: 18 January 1999.\n");              
       sb.append("\n");
       sb.append("Copyright 1999 DW Software.\n");
       sb.append("\n");
       sb.append("This is the "+VerInfo.getJavaVer()+" build.\n");
       sb.append(VerInfo.getLongBuild()+"\n");
       sb.append("\n");
       sb.append("Running Java "+System.getProperty("java.version")+" from "+System.getProperty("java.vendor")+".\n");
       sb.append("Free memory: " + r.freeMemory()/1024 + " KB\n");
       sb.append("Total memory: " + r.totalMemory()/1024 + " KB\n");
       sb.append("Memory in use: " + (r.totalMemory() - r.freeMemory())/1024 + " KB");

       JOptionPane.showMessageDialog(this, sb.toString(), "JPeriod99 -- ["+VerInfo.getBuild()+"]", JOptionPane.INFORMATION_MESSAGE);
   }

   public void OnFileSave() {
     try {
	    SimpleFileFilter filter = new SimpleFileFilter("txt", "Text File");
       String fname = DoFileDialog.GetFileName(this, "Save Element Data...", FileDialog.SAVE, filter);
       if(fname.equals("")) return;
       sb.setText("Saving "+fname+"...");
       FileOutputStream outFile = new FileOutputStream(fname);
       DataOutputStream os = new DataOutputStream(new BufferedOutputStream(outFile));

       String x = AllElementInfo.getAtomInfoAsText(ppmgr.getSelection(), dbmgr);

       os.writeBytes(x);
       os.writeBytes(cfgmgr.getCrlf());

       os.flush();
       outFile.close();
       sb.setText("Saved "+fname+".");
     } catch (Exception e){
       e.printStackTrace();
     }
   }

   public void OnFileSaveAll() {
     try {
	    SimpleFileFilter filter = new SimpleFileFilter("txt", "Text File");
       String fname = DoFileDialog.GetFileName(this, "Save Element Data...", FileDialog.SAVE, filter);
       if(fname.equals("")) return;
       sb.setText("Saving "+fname+"...");
       FileOutputStream outFile = new FileOutputStream(fname);
       DataOutputStream os = new DataOutputStream(new BufferedOutputStream(outFile));

       dbmgr.saveEverything(os);

       os.writeBytes(cfgmgr.getCrlf());

       os.flush();
       outFile.close();
       sb.setText("Saved "+fname+".");
     } catch (Exception e){
       e.printStackTrace();
     }
   }

   public void OnFilePrintEverything() {}

   public void OnFileSaveDatabase() {
     try {
	    SimpleFileFilter filter = new SimpleFileFilter("tsv", "Tab Separated Values");
       String fname = DoFileDialog.GetFileName(this, "Save Database...", FileDialog.SAVE, filter);
       if(fname.equals("")) return;

       sb.setText("Saving "+fname+"...");
       InputStream s = iomgr.getInputStream(DatabaseManager.ElementsDB);
       FileOutputStream outFile = new FileOutputStream(fname);

       byte b[] = new byte[16384];
       int x = 0;

       while((x = s.read(b)) >= 16384) {
           outFile.write(b);
       };

       outFile.write(b, 0, x);

       outFile.flush();
       outFile.close();
       s.close();
       sb.setText("Saved "+fname+".");
     } catch (Exception e){
       e.printStackTrace();
     }
   }

   public void OnHelpAboutVM() {
       JSystemInfo si = new JSystemInfo();
       String btns[] = {"Refresh"};
       JComponentDialog cd = new JComponentDialog(this, "About Java VM", si, si, btns);
   }

   protected void makeWindowEvent(WindowEvent we) {
       processWindowEvent(we);
   }
}