import javax.swing.*;
import java.awt.image.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;

public class AtomAni extends JPanel implements IPanelListener, Runnable, ActionListener, ChangeListener {
   public atom model;
   private JButton start = new JButton("Start");
   private JButton stop = new JButton("Stop");
   private JSlider speed = new JSlider(0, 2000, 500);
   private JLabel lSpeed = new JLabel("500ms");
   private Thread t;

   private Image iBuffer;

   public String toString() {return "Electron Animation";}

   public AtomAni() {
       setLayout(new FlowLayout(FlowLayout.LEFT));
       add(start);
       start.addActionListener(this);
       add(stop);
       stop.addActionListener(this);
       add(lSpeed);
       add(speed);
       speed.addChangeListener(this);

       lSpeed.setForeground(Color.white);
       setBackground(Color.black);

       int radius = Math.min(getSize().width, getSize().height);
       model = new atom(1,1, radius, radius);
       startDraw();
   }

   public void stateChanged(ChangeEvent e) {
       delay = speed.getValue();
       lSpeed.setText(delay+"ms");
   }

   private int delay = 500;
   private int radius; //actually it's the DIAMETER!

   public void paint(Graphics g) {
       super.paint(g);

       Dimension d = getSize();
       int r = Math.min(d.width, d.height);
       if ((iBuffer==null)||(radius!=r)) {
           iBuffer = createImage(r,r);
           int n = model.AtomicNumber;
           model = new atom(n, n, r,r);
           radius = r;
       }
       Graphics gBuffer = (Graphics)iBuffer.getGraphics();
       gBuffer.setColor(Color.black);
       gBuffer.fillRect(0,0,d.width,d.height);

       gBuffer.setColor(Color.white);
       model.draw(gBuffer, r/2, r/2);

       g.drawImage(iBuffer, (d.width - r), (d.height-r)/2, null, null);
   }

   public void actionPerformed(ActionEvent e){
       if(e.getSource() == start) {startDraw();}
       else if(e.getSource() == stop){stopDraw();}
   }

   public void run() {
       while(true) {
           if(killNow) return;
           repaint();
           try {Thread.sleep(delay);} catch(Exception e) {}
       }
   }

   public void setAtom(PanelEvent pe) {
       model.setAtomicNumber(pe.getElement().AtomicNumber);
   }

   public void onActivate(PanelEvent pe){startDraw();}
   public void onDeactivate(PanelEvent pe){stopDraw();}

   private boolean killNow = false;

   private void startDraw() {
       killNow = false;
       t = new Thread(this);
       t.setDaemon(true);
       t.start();
   }
   private void stopDraw() {killNow = true;}

   public void setStyle(PanelEvent pe) {}   
}

class atom {
   int AtomicNumber=-1;
   int mass=1;
   int width=100;
   int height=100;
   double radius=100.0;
   Electron electrons[]=null;
   int max_Electron=0;
   int electron_size;
   int nucleon_size;
   int start=1;
   int iRadius;
//   int testcount=0;

   atom() {
       init();
   }

   atom(int index, int m_sse, int w_dth, int h_ight)
   {
       AtomicNumber=index;
       mass=m_sse;
       height=h_ight;
       width=w_dth;
       radius=Math.min(height,width);
       iRadius=Math.min(height,width);
       init();
   }

   public void init()
   {
       electrons=new Electron[7];
       AtomicNumber=Math.max(1,Math.min(AtomicNumber,118));
       initSystem();
       nucleon_size= Math.min((int) (radius/(7)/2),25);
   }

   private void initSystem() {
       int an = AtomicNumber;
       setAtomicNumber(118);
       setAtomicNumber(an);
   }

   public void setAtomicNumber(int number)
   {
       if(AtomicNumber == number) return;
       AtomicNumber = number;
       int akt_Electron=0;
       int orbital=0;
       int i=0;
       int max;

       for (int n=0; n<7; n++) {
           max=0;
           for (int j=0; j<=n; j++)
               max+=-2+(j+1)*4;
           electrons[n]=new Electron(this, max, 0., 0.1);
       }

       while(i<number)
       {
           if (akt_Electron==0) {akt_Electron=1; orbital=1;}
           else if (orbital>1) {akt_Electron++; orbital--;}
           else {
               int dummy_Electron=akt_Electron;

               akt_Electron=(akt_Electron+1)/2+1;
               orbital=dummy_Electron/2+1;
           }

           max=-2+orbital*4;

           max_Electron=Math.max(akt_Electron,max_Electron);

           while((i<number) && (max>0))
           {
               electrons[akt_Electron-1].actual+=1;
               i++;
               max--;
           }
       }
       for (i=0; i<max_Electron; i++)
           electrons[i].set_settings(0.9*radius/(max_Electron-i)/2, Math.min((int) (radius/(max_Electron*max_Electron)*1.5),8));
   }

   public void draw(Graphics g, int x0, int y0) {
       for (int i=0; i<max_Electron; i++) {

           g.drawOval(x0-(int) (electrons[i].radius), y0-(int) (electrons[i].radius), 2*(int) (electrons[i].radius), 2*(int) (electrons[i].radius));
           electrons[i].draw(g,x0,y0);
       }
//       testcount++;
//       g.drawString("AtomAni Number: "+Integer.toString(AtomicNumber),5,30);
       g.setColor(Color.red);
       g.fillOval(x0-((int)nucleon_size/2),y0-((int)nucleon_size/2),nucleon_size,nucleon_size);
//       g.drawImage(p.core_image, x0-(int)nucleon_size/2,y0-(int)nucleon_size/2, nucleon_size, nucleon_size,p);
   }
}

class Electron {
   int max=1;
   int actual=0;
   double radius=100.;
   double angles[]=null;
   double d_angles=1.;
   int x[]=null;
   int y[]=null;
   int electron_size;
   int first=1;
   atom parent;

   Electron(atom a, int m_x, double w_nkel, double d_w_nkel) {
       parent = a;
       max=m_x;
       angles=new double[max];
       x=new int[max];
       y=new int[max];
       for (int i=0; i<max; i++) {
           angles[i]=w_nkel;
           d_angles=d_w_nkel*(1.+0.2*Math.random());
       }
   }

   public void move() {
       for (int i=0; i<max; i++) {
           angles[i]+=d_angles;
           x[i]=(int) (radius*Math.cos(angles[i]));
           y[i]=(int) (radius*Math.sin(angles[i]));
       }
   }

   public void draw(Graphics g, int x0, int y0) {
       x0=x0-electron_size/2;
       y0=y0-electron_size/2;
       if (first>0) { move(); first=0; }
       if (parent.start>0) { move(); first=0; }

       for (int i=0; i<actual; i++) {
           g.setColor(Color.blue);
           g.fillOval(x0+x[i], y0+y[i], electron_size, electron_size);
//           g.drawImage(p.electron_image,x0+x[i],y0+y[i],electron_size,electron_size,p);
           g.setColor(Color.white);
       }
   }

   public void set_settings(double r_dius, int _lectron_size) {
       radius=r_dius;
       electron_size=_lectron_size;
       for (int i=0; i<max; i++) {
           angles[i]+=i*Math.PI*2./actual;
       }
   }
}

