/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class AllElementInfo
extends JScrollPane
implements ActionListener,
IPanelListener {
    private Map elements;
    private Map types;
    private Map classes;
    private Map states;
    private PropertyPanelManager ppmgr;
    private DatabaseManager dbmgr;
    private ConfigManager cfgmgr;
    private JTable j = new JTable();
    private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 67);
    private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 80);
    private JMenu pmContext = new JCoolMenu("Panel");
    private int currSelection = -1;
    Object[][] data;
    TableModel dataModel = new 1();
    private static final int NUM_CLASSES = 73;
    private static final String[] categories = new String[]{"Name", "Atomic Number", "Symbol", "Element Type", "State", "Mass (amu)", "Relative Mass", "Melts at (K)", "Boils at (K)", "Valency", "Discovery Date", "Discoverer", "Name Origin", "Uses", "Obtained From", "Electron Config", "Electronegativity", "Density (g/cm^3)", "Ionization Energy (eV)", "Specific Heat (cal/g K)", "Vaporization (Kcal / g*atom)", "Atomic Radii (ang)", "Class Type", "Sanderson Electronegativity", "Rochow Electronegativity", "Mulliken Electronegativity", "Allen Electronegativity", "g of element / kg of human", "Zeff for 1s", "Zeff for 2s", "Zeff for 2p", "Zeff for 3s", "Zeff for 3p", "Zeff for 3d", "Zeff for 4s", "Zeff for 4p", "Zeff for 4d", "Zeff for 4f", "Zeff for 5s", "Zeff for 5p", "Zeff for 5d", "Zeff for 6s", "Zeff for 6p", "Zeff for 7s", "Electron Affinity (kJ/mol)", "Molar Volume (cm^3)", "Resistivity (u-ohms)", "Abundances", "Hazards", "Universe (ppb by Weight)", "Universe (ppb by Atom)", "Sun (ppb by Weight)", "Sun (ppb by Atom)", "Meteorites (ppb by Weight)", "Meteorites (ppb by Atom)", "CrustalRocks (ppb by Weight)", "CrustalRocks (ppb by Atom)", "SeaWater (ppb by Weight)", "SeaWater (ppb by Atom)", "Stream (ppb by Weight)", "Stream (ppb by Atom)", "Human (ppb by Weight)", "Human (ppb by Atom)", "Covalent Radius (\u00c5)", "CAS Registry Number", "Crystal Structure", "Atomic Volume (cm^3/mol)", "Heat of Vaporization (kJ/mol)", "Thermal Conductivity (W/cmK)", "Heat of Fusion (kJ/mol)", "1st Ion Potential (V)", "2nd Ion Potential (V)", "3rd Ion Potential (V)", ""};

    public AllElementInfo(PropertyPanelManager propertyPanelManager, DatabaseManager databaseManager, ConfigManager configManager) {
        this.dbmgr = databaseManager;
        this.ppmgr = propertyPanelManager;
        this.cfgmgr = configManager;
        this.elements = this.dbmgr.getElements();
        this.types = this.dbmgr.getTypes();
        this.classes = this.dbmgr.getClasses();
        this.states = this.dbmgr.getStates();
        Font font = this.j.getFont();
        this.j.setFont(new Font(font.getName(), 0, 20));
        this.j.setRowHeight(this.j.getRowHeight() + 10);
        this.j.setSelectionMode(0);
        this.setViewportView(this.j);
        this.j.setCellSelectionEnabled(false);
        if (this.cfgmgr.canGetClipboard()) {
            this.miCopyToClipboard.addActionListener(this);
            this.miCopyToClipboard.setActionCommand("CopyToClipboard");
            this.pmContext.add(this.miCopyToClipboard);
        }
        if (this.cfgmgr.canPrint()) {
            this.miPrintGraph.addActionListener(this);
            this.miPrintGraph.setActionCommand("FilePrintTable");
            this.pmContext.add(this.miPrintGraph);
        }
        this.pmContext.setMnemonic('P');
    }

    public void setAtom(PanelEvent panelEvent) {
        TElement tElement = panelEvent.getElement();
        Object[][] objectArray = new Object[73][2];
        int n = 0;
        while (n < 73) {
            objectArray[n][0] = AllElementInfo.getCategories(n);
            objectArray[n][1] = AllElementInfo.retrieveData(tElement, n, this.dbmgr);
            ++n;
        }
        this.data = objectArray;
        this.j.setModel(this.dataModel);
        this.j.repaint();
        this.currSelection = tElement.AtomicNumber;
    }

    public void onActivate(PanelEvent panelEvent) {
        this.ppmgr.addMenu(this.pmContext);
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.ppmgr.removeMenu(this.pmContext);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CopyToClipboard")) {
            this.OnCopyToClipboard();
            return;
        }
        string.equals("FilePrintTable");
    }

    private void OnCopyToClipboard() {
        int n = this.currSelection;
        Object object = this.dbmgr;
        StringSelection stringSelection = new StringSelection(AllElementInfo.getAtomInfoAsText((TElement)((DatabaseManager)object).getElements().get(new Integer(n)), (DatabaseManager)object));
        object = Toolkit.getDefaultToolkit().getSystemClipboard();
        ((Clipboard)object).setContents(stringSelection, stringSelection);
    }

    public static String getAtomInfoAsText(int n, DatabaseManager databaseManager) {
        return AllElementInfo.getAtomInfoAsText((TElement)databaseManager.getElements().get(new Integer(n)), databaseManager);
    }

    public static String getAtomInfoAsText(TElement tElement, DatabaseManager databaseManager) {
        if (tElement == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 73) {
            stringBuffer.append(AllElementInfo.getCategories(n));
            stringBuffer.append("\t\t");
            stringBuffer.append(AllElementInfo.retrieveData(tElement, n, databaseManager));
            stringBuffer.append("\r\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String retrieveData(TElement tElement, int n, DatabaseManager databaseManager) {
        switch (n) {
            case 0: {
                return tElement.Name;
            }
            case 1: {
                return Integer.toString(tElement.AtomicNumber);
            }
            case 2: {
                return tElement.Symbol;
            }
            case 3: {
                return TElementType.getTypeName(tElement.ElementType, databaseManager.getTypes());
            }
            case 4: {
                return TState.getStateName(tElement.State, databaseManager.getStates());
            }
            case 5: {
                return Float.toString(tElement.Mass);
            }
            case 6: {
                return Integer.toString(tElement.RelativeMass);
            }
            case 7: {
                float f = tElement.Melting;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 8: {
                float f = tElement.Boiling;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 9: {
                return tElement.Valency;
            }
            case 10: {
                if (tElement.DateDiscovered == 0) {
                    return "Ancient";
                }
                return Integer.toString(tElement.DateDiscovered);
            }
            case 11: {
                return tElement.Discoverer;
            }
            case 12: {
                return tElement.NameOrigin;
            }
            case 13: {
                return tElement.Uses;
            }
            case 14: {
                return tElement.ObtainedFrom;
            }
            case 15: {
                return tElement.ElectronConfig;
            }
            case 16: {
                float f = tElement.Electronegativity;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 17: {
                float f = tElement.Density;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 18: {
                float f = tElement.Ionization;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 19: {
                float f = tElement.SpecificHeat;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 20: {
                float f = tElement.Vaporization;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 21: {
                float f = tElement.AtomicRadii;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 22: {
                return TClass.getClassName(tElement.ClassType, databaseManager.getClasses());
            }
            case 23: {
                float f = tElement.Sanderson;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 24: {
                float f = tElement.Rochow;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 25: {
                float f = tElement.Mulliken;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 26: {
                float f = tElement.Allen;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 27: {
                return Float.toString(tElement.gperkg);
            }
            case 28: {
                float f = tElement.zeff_s1;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 29: {
                float f = tElement.zeff_s2;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 30: {
                float f = tElement.zeff_p2;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 31: {
                float f = tElement.zeff_s3;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 32: {
                float f = tElement.zeff_p3;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 33: {
                float f = tElement.zeff_d3;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 34: {
                float f = tElement.zeff_s4;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 35: {
                float f = tElement.zeff_p4;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 36: {
                float f = tElement.zeff_d4;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 37: {
                float f = tElement.zeff_f4;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 38: {
                float f = tElement.zeff_s5;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 39: {
                float f = tElement.zeff_p5;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 40: {
                float f = tElement.zeff_d5;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 41: {
                float f = tElement.zeff_s6;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 42: {
                float f = tElement.zeff_p6;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 43: {
                float f = tElement.zeff_s7;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 44: {
                float f = tElement.affinity;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 45: {
                float f = tElement.molar_volume;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 46: {
                float f = tElement.sound_velocity;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 47: {
                return tElement.abundances;
            }
            case 48: {
                return tElement.hazards;
            }
            case 49: {
                float f = tElement.UniverseByWeight;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 50: {
                float f = tElement.UniverseByAtom;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 51: {
                float f = tElement.SunByWeight;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 52: {
                float f = tElement.SunByAtom;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 53: {
                float f = tElement.MeteoritesByWeight;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 54: {
                float f = tElement.MeteoritesByAtom;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 55: {
                float f = tElement.CrustalRocksByWeight;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 56: {
                float f = tElement.CrustalRocksByAtom;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 57: {
                float f = tElement.SeaWaterByWeight;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 58: {
                float f = tElement.SeaWaterByAtom;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 59: {
                float f = tElement.StreamByWeight;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 60: {
                float f = tElement.StreamByAtom;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 61: {
                float f = tElement.HumanByWeight;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 62: {
                float f = tElement.HumanByAtom;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 63: {
                float f = tElement.CovalentRadius;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 64: {
                return tElement.CASRegistry;
            }
            case 65: {
                return tElement.Crystal;
            }
            case 66: {
                float f = tElement.AtomicVol;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 67: {
                float f = tElement.HVaporization;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 68: {
                float f = tElement.ThermConductivity;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 69: {
                float f = tElement.HFusion;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 70: {
                float f = tElement.PIonPotent;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 71: {
                float f = tElement.SIonPotent;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
            case 72: {
                float f = tElement.TIonPotent;
                if ((double)f == -1.0) {
                    return "Unknown";
                }
                return Float.toString(f);
            }
        }
        throw new IllegalArgumentException("Categories range from 0 to " + 72 + ".");
    }

    private static String procFloat(float f) {
        if ((double)f == -1.0) {
            return "Unknown";
        }
        return Float.toString(f);
    }

    private static String getCategories(int n) {
        if (n < 0 || n >= 73) {
            throw new IllegalArgumentException("Categories range from 0 to " + 72 + ".");
        }
        return categories[n];
    }

    private void OnFilePrintTable() {
    }

    public String toString() {
        return "All Properties";
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }

    private final class 1
    extends AbstractTableModel {
        final String[] names = new String[]{"Property", "Value"};

        public int getColumnCount() {
            return this.names.length;
        }

        public int getRowCount() {
            return AllElementInfo.this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return AllElementInfo.this.data[n][n2];
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public Class getColumnClass(int n) {
            return AllElementInfo.this.data[0][n].getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        /* synthetic */ 1() {
        }
    }
}

